<?php
include 'includes/header.php';
require_once '../config/database.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ./login.php');
    exit();
}

$database = new Database();
$db = $database->getConnection();

// Handle status update
if (isset($_POST['update_status'])) {
    $update_query = "UPDATE test_drives SET status = ? WHERE id = ?";
    $update_stmt = $db->prepare($update_query);
    $update_stmt->execute([$_POST['status'], $_POST['test_drive_id']]);
}

// Get all test drives with pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10;
$offset = ($page - 1) * $per_page;

$test_drives_query = "SELECT t.*, c.title as car_title, u.first_name, u.last_name, u.email, u.phone 
                     FROM test_drives t 
                     JOIN cars c ON t.car_id = c.id 
                     JOIN users u ON t.user_id = u.id 
                     ORDER BY t.preferred_date DESC 
                     LIMIT $offset, $per_page";
$test_drives_stmt = $db->query($test_drives_query);

$total_test_drives = $db->query("SELECT COUNT(*) FROM test_drives")->fetchColumn();
$total_pages = ceil($total_test_drives / $per_page);
?>

<div class="container py-5">
    <h2>Manage Test Drives</h2>
    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Car</th>
                            <th>Customer</th>
                            <th>Contact</th>
                            <th>Date & Time</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($test_drive = $test_drives_stmt->fetch(PDO::FETCH_ASSOC)): ?>
                            <tr>
                                <td><?php echo $test_drive['car_title']; ?></td>
                                <td><?php echo $test_drive['first_name'] . ' ' . $test_drive['last_name']; ?></td>
                                <td>
                                    Email: <?php echo $test_drive['email']; ?><br>
                                    Phone: <?php echo $test_drive['phone']; ?>
                                </td>
                                <td>
                                    <?php echo date('M d, Y', strtotime($test_drive['preferred_date'])); ?><br>
                                    <?php echo date('h:i A', strtotime($test_drive['preferred_time'])); ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php 
                                        echo $test_drive['status'] === 'Approved' ? 'success' : 
                                            ($test_drive['status'] === 'Pending' ? 'warning' : 
                                            ($test_drive['status'] === 'Completed' ? 'info' : 'danger')); 
                                    ?>">
                                        <?php echo $test_drive['status']; ?>
                                    </span>
                                </td>
                                <td>
                                    <form method="POST">
                                        <input type="hidden" name="test_drive_id" value="<?php echo $test_drive['id']; ?>">
                                        <select name="status" class="form-select form-select-sm mb-2">
                                            <option value="Pending" <?php echo $test_drive['status'] === 'Pending' ? 'selected' : ''; ?>>Pending</option>
                                            <option value="Approved" <?php echo $test_drive['status'] === 'Approved' ? 'selected' : ''; ?>>Approved</option>
                                            <option value="Rejected" <?php echo $test_drive['status'] === 'Rejected' ? 'selected' : ''; ?>>Rejected</option>
                                            <option value="Completed" <?php echo $test_drive['status'] === 'Completed' ? 'selected' : ''; ?>>Completed</option>
                                        </select>
                                        <button type="submit" name="update_status" class="btn btn-sm btn-primary">Update</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if ($total_pages > 1): ?>
                <nav aria-label="Page navigation" class="mt-4">
                    <ul class="pagination justify-content-center">
                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                            <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?> 